function [mask_fpi]=refined_fpi(fpi_contour,fpi_pixel,cs_corrected_wwfR_gray,edge_wwf)
% From the two firing pin impression masks, one is selected
% The selected mask is augmented with sections from the illumination
% corrected region of interest(i.e.cs_corrected_wwfR_gray)

%% input
% fpi_contour : firing pin impression mask identified using contour based
%               method
% fpi_pixel : firing pin impression mask identified using pixel based
%             method
% cs_corrected_wwfR_gray : illumination corrected(i.e. planar bias and
%                          circular symmetry corrected), registered/unregistered region of interest
%                          consisting of breech face region, flowback and
%                          firing pin impression.
% 
%% output
% mask_fpi : the final firing pin impression binary mask to be used for
%            segmentation of the firing pin impression from other parts of
%            the region of interest(i.e. flowback and breech face region)

[r1, c1]=size(cs_corrected_wwfR_gray);
FP=zeros(r1,c1);
[xf yf ]=find_logical(fpi_contour);


[xf1 yf1]=find_logical(fpi_pixel);


% find connected com with max intersections with winner FPI,
%add it to FPI

SE= double(cs_corrected_wwfR_gray)< mean(double(cs_corrected_wwfR_gray(:)))-std(double(cs_corrected_wwfR_gray(:)));
EJbw_filled=imfill(edge_wwf,'holes');

WE=SE.*EJbw_filled;

We_c=bwmorph(WE,'clean');

% find all connected components
WS=bwlabel(We_c,8);

WS_rpl=regionprops(WS,'PixelList');

B_fps= intersectRows([yf1 xf1],[yf xf]);
if isempty(B_fps)==0 % If the 2 Firing Pin impressions FF and FF1 intersect
   
    p=tocheckifSubset([yf1 xf1],[yf xf]);  % check if FF1 is a subset of FF
    p1=tocheckifSubset([yf xf],[yf1 xf1]);  % check if FF is a subset of FF1
    if p==1 & p1==1          %both are subset of each other - same
        FP=fpi_contour;
        c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8); % check Coverage function needs checking
        if c==1
            FP=zeros(r1,c1);
            FP=fpi_pixel;
        end
    elseif p1==1 & p==0         % FF is a subset of FF1
        FP=fpi_pixel;
        % look for flowback region of FF1 on the whole BFgn image with FPI 
%         c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%         if c==1
%             FP=zeros(r1,c1);
%             FP=fpi_contour;
%         end
    elseif p1==0 & p==1        % FF1 is a subset of FF
        FP=fpi_contour;
        c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
        if c==1
            FP=zeros(r1,c1);
            FP=fpi_pixel;
        end
        % c2 - FF and FF1 intersect but are not subsets
    else
        % the logic that goes here is
        
        %find the component that has a greater intersection with the connected component
        %from BFgn if none in either case , select component with largest
        %area of the two
        
        if isempty(WS_rpl)==0
            inter=[];inter1=[];
            for i=1:length(WS_rpl)
                px=WS_rpl(i).PixelList;
                xIk=px(:,2);
                yIk=px(:,1);
                % find component with which each has max intersection
                Bin1=intersectRows([yIk xIk],[yf1 xf1]);
                Bin=intersectRows([yIk xIk],[yf xf]);
                inter(i)=size(Bin,1);
                inter1(i)=size(Bin1,1);
            end
            %find max
            [v1 mi1]=max(inter1);
            [v mi]=max(inter);
            if v>0 & v1==0
                FP=fpi_contour;
%                 c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%                 if c==1
%                     FP=zeros(r1,c1);
%                     FP=fpi_pixel;
%                 end
            elseif v1>0 & v==0
                FP=fpi_pixel;
                c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
                if c==1
                    FP=zeros(r1,c1);
                    FP=fpi_contour;
                end
            elseif v1>0 & v>0
                %whichever has a greater intersection
                %                      d=length(xf);
                %                      d1=length(xf1);
                if v>v1
                    FP=fpi_contour;
%                     c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%                     if c==1
%                         FP=zeros(r1,c1);
%                         FP=fpi_pixel;
%                     end
                else
                    FP=fpi_pixel;
                    c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
                    if c==1
                        FP=zeros(r1,c1);
                        FP=fpi_contour;
                    end
                end
            else
                % if BFgn is not empty - but the candidate fpis ff and ff1
                % intersect among themselves but not with BFgn (v=0 and
                % v1=0;
                d=length(xf);
                d1=length(xf1);
                
                if d>d1
                    FP=fpi_contour;
%                     c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%                     if c==1
%                         FP=zeros(r1,c1);
%                         FP=fpi_pixel;
%                     end
                else
                    FP=fpi_pixel;
%                     c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%                     if c==1
%                         FP=zeros(r1,c1);
%                         FP=fpi_contour;
%                     end
                end
            end
            % if no component in BFgn intersects select component use larger
            % area
        else
            d=length(xf);
            d1=length(xf1);
            
            if d>d1
                FP=fpi_contour;
%                 c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%                 if c==1
%                     FP=zeros(r1,c1);
%                     FP=fpi_pixel;
%                 end
            else
                FP=fpi_pixel;
                c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
                if c==1
                    FP=zeros(r1,c1);
                    FP=fpi_contour;
                end
            end
        end
    end
    
    % c3 - FF and FF1 do not intersect with each other
else
    if isempty(xf)==0 & isempty(xf1)==0
    %check solidity of the two components
    FF_bw=bwlabel(fpi_contour,8);
    FF1_bw=bwlabel(fpi_pixel,8);
    
    FF_brpl=regionprops(FF_bw,'Solidity');
    FF1_brpl=regionprops(FF1_bw,'Solidity');
    
    if FF_brpl(1).Solidity > FF1_brpl(1).Solidity
        FP=fpi_contour;
%         c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%         if c==1
%             FP=zeros(r1,c1);
%             FP=fpi_pixel;
%         end
    else
        FP=fpi_pixel;
%         c=checkCoverage(edge_wwf,cs_corrected_wwfR_gray,FP,0.8);
%         if c==1
%             FP=zeros(r1,c1);
%             FP=fpi_contour;
%         end
           
    end
  elseif isempty(xf)==0 & isempty(xf1)==1
      FP=fpi_contour;
    elseif isempty(xf)==1 & isempty(xf1)==0
      FP=fpi_pixel;
    end

end

%% The binarized mask of the selected firing pin impression is augmented (if possible) 
%   with sections from the illumination corrected region of interest

mask_fpi=FP;
for x=1:length(WS_rpl)
    In=zeros(r1,c1);
    pix=WS_rpl(x).PixelList;
    for y=1:size(pix,1)
        In(pix(y,2),pix(y,1))=1;
    end
    [xi yi]=find_logical(In);
    [xfp, yfp]=find_logical(FP);
    Bii=intersectRows([yfp xfp],[yi xi]);
    if isempty(Bii)==0
        mask_fpi=FP+In;
    end
end
mask_fpi=logical(mask_fpi);
